package row_data_gateway;
import db_context.DbContext;

import java.sql.*;

public class Transport {
    private Integer id;
    private String route;
    private java.sql.Timestamp departure_time;
    private java.sql.Timestamp arrival_time;
    private Integer package_id;
    private Integer starting_loc_id;
    private Integer destination_loc_id;

    public Integer getId() {
        return id;
    }
    public void setId(Integer id) {
        this.id = id;
    }

    public String getRoute() {
        return route;
    }
    public void setRoute(String route) {
        this.route = route;
    }

    public Timestamp getDeparture_time() {
        return departure_time;
    }
    public void setDeparture_time(Timestamp departure_time) {
        this.departure_time = departure_time;
    }

    public Timestamp getArrival_time() {
        return arrival_time;
    }
    public void setArrival_time(Timestamp arrival_time) {
        this.arrival_time = arrival_time;
    }

    public Integer getPackage_id() {
        return package_id;
    }
    public void setPackage_id(Integer package_id) {
        this.package_id = package_id;
    }

    public Integer getStarting_loc_id() {
        return starting_loc_id;
    }
    public void setStarting_loc_id(Integer starting_loc_id) {
        this.starting_loc_id = starting_loc_id;
    }

    public Integer getDestination_loc_id() {
        return destination_loc_id;
    }
    public void setDestination_loc_id(Integer destination_loc_id) {
        this.destination_loc_id = destination_loc_id;
    }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO transports (route, departure_time, arrival_time, package_id, starting_loc_id, destination_loc_id) VALUES (?,?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, route);
            //s.setTimestamp(2, departure_time);
            //s.setTimestamp(3, arrival_time);
            s.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            s.setTimestamp(3, new Timestamp(System.currentTimeMillis()+ 259200000));
            s.setInt(4, package_id);
            s.setInt(5, starting_loc_id);
            s.setInt(6, destination_loc_id);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE transports SET route = ?, departure_time = ?, arrival_time = ?, package_id = ?, starting_loc_id = ?, destination_loc_id = ? WHERE id = ?")) {
            s.setString(1, route);
            s.setTimestamp(2, departure_time);
            s.setTimestamp(3, arrival_time);
            s.setNull(4, java.sql.Types.INTEGER);
            s.setNull(5, java.sql.Types.INTEGER);
            s.setNull(6, java.sql.Types.INTEGER);
            s.setInt(7, id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM transports WHERE id = ?")) {
            s.setInt(1, id);
            s.executeUpdate();
        }
    }
}
